/**
 * 
 */
package com.ejie.ab18a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aConfiguracionAplicacion;

/**
 * @author XXXX
 * 
 */
@Repository()
@Transactional()
public class Ab18aConfiguracionAplicacionDaoImpl implements
		Ab18aConfiguracionAplicacionDao {

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aConfiguracionAplicacion> rwMap = new RowMapper<Ab18aConfiguracionAplicacion>() {
		public Ab18aConfiguracionAplicacion mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {
			return new Ab18aConfiguracionAplicacion(
					resultSet.getInt("T00IDCONFIGURACIONAPLICACION"),
					resultSet.getString("T00DESCES"),
					resultSet.getString("T00DESCEU"),
					resultSet.getBoolean("T00VALOR"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Transactional(readOnly = true)
	public Ab18aConfiguracionAplicacion find(Integer idConfiguracion) {
		String query = "SELECT t1.T00_ID_CONF_APLIC T00IDCONFIGURACIONAPLICACION, t1.T00_DESC_ES T00DESCES, t1.T00_DESC_EU T00DESCEU, t1.T00_VALOR T00VALOR FROM AB18A00S00 t1  WHERE t1.T00_ID_CONF_APLIC = ?  ";

		List<Object> params = new ArrayList<Object>();
		params.add(idConfiguracion);
		List<Ab18aConfiguracionAplicacion> configuracionAplicacionList = this.jdbcTemplate
				.query(query, this.rwMap, params.toArray());
		return (Ab18aConfiguracionAplicacion) DataAccessUtils
				.uniqueResult(configuracionAplicacionList);
	}
}
